#include <iostream>
#include <vector>
using namespace std;
vector<int> merge(vector<int>& left, vector<int>& right) {
    vector<int> sorted;
    int i = 0, j = 0;

    while (i < left.size() && j < right.size()) {
        if (left[i] < right[j]) {
            sorted.push_back(left[i]);
            i++;
        } else {
            sorted.push_back(right[j]);
            j++;
        }
    }

    while (i < left.size()) {
        sorted.push_back(left[i]);
        i++;
    }

    while (j < right.size()) {
        sorted.push_back(right[j]);
        j++;
    }

    return sorted;
}
vector<int> mergeSort(vector<int>& arr) {
    if (arr.size() <= 1) {
        return arr;
    }

    int middle = arr.size() / 2;
    vector<int> left(arr.begin(), arr.begin() + middle);
    vector<int> right(arr.begin() + middle, arr.end());

    left = mergeSort(left);
    right = mergeSort(right);

    return merge(left, right);
}



int main() {
    vector<int> lista;
    int num;

    while (cin >> num) {
        lista.push_back(num);
    }

    vector<int> sortedList = mergeSort(lista);

    int x = sortedList[0];
    int y = sortedList[1];
    int z = sortedList[sortedList.size() - 1] - x - y;

    cout << x << " " << y << " " << z << endl;

    return 0;
}